package gov.va.med.mhv.sm.api.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import javax.ws.rs.core.Response;

import org.apache.http.client.utils.DateUtils;
import org.apache.cxf.jaxrs.ext.ResponseHandler;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.message.Message;

public class SMApiResponseHandler implements ResponseHandler {

	@Override
	public Response handleResponse(Message outputMessage,
			OperationResourceInfo invokedOperation, Response response) {

		//ONLY ADD AN EXPIRES NOW IF THERE IS NO EXPIRES
		if( !response.getHeaders().containsKey("Expires") ) {
			Map<String, List<String>> headers = (Map<String, List<String>>) outputMessage.get(Message.PROTOCOL_HEADERS);
			if (headers == null) {
				headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
			}
			List<String> list = new ArrayList<String>();
			list.add(DateUtils.formatDate(new Date()));
			headers.put("Expires", list);
			outputMessage.put(Message.PROTOCOL_HEADERS, headers);
		}
		return response;
	}

}
